﻿using System.Windows;

namespace WPF.PresentationLayer.Behaviors
{
    /// <summary>
    /// DataGridTextColumn or any other supported dataGrid columns doesn't lie in Visual tree 
    /// of DataGrid. Hence, by default it doesn't inherit DataContext of DataGrid. As a workaround
    /// we can use this class to get access to the DataContext by storing it in the Data object
    /// </summary>
    public class DataGridBindingProxy : Freezable
    {
        #region Overrides of Freezable

        protected override Freezable CreateInstanceCore()
        {
            return new DataGridBindingProxy();
        }

        #endregion
        /// <summary>
        /// Data that holds onto the DataGrids DataContext
        /// </summary>
        public object Data
        {
            get { return (object)GetValue(DataProperty); }
            set { SetValue(DataProperty, value); }
        }

        /// <summary>
        /// Data dependency property
        /// </summary>
        public static readonly DependencyProperty DataProperty =
            DependencyProperty.Register("Data", typeof(object),
                                         typeof(DataGridBindingProxy));
    }
}
